/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.reflect.ClassPath;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockBanner;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketScoreboardObjective;
import net.minecraft.network.play.server.SPacketUpdateScore;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.GenericEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomRegisters;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.event.ItemEvent;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.api.handler.data.IWorldInfo;
import noppes.npcs.api.item.INPCToolItem;
import noppes.npcs.api.item.ISpecBuilder;
import noppes.npcs.api.mixin.entity.IEntityLivingBaseMixin;
import noppes.npcs.api.mixin.entity.player.IEntityPlayerMixin;
import noppes.npcs.api.mixin.tileentity.ITileEntityBanner;
import noppes.npcs.api.wrapper.BlockWrapper;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.client.ClientEventHandler;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.KeyController;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.PlayerSkinController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.PlayerScriptData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.dimensions.CustomWorldInfo;
import noppes.npcs.dimensions.DimensionHandler;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataInventory;
import noppes.npcs.entity.data.Resistances;
import noppes.npcs.items.ItemBoundary;
import noppes.npcs.items.ItemNbtBook;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.quests.QuestObjective;
import noppes.npcs.reflection.event.entity.living.LivingAttackEventReflection;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.Util;
import org.apache.commons.lang3.StringUtils;

public class PlayerEventHandler {
    private static final String[] pathsToForgeEventClasses = new String[]{"net.minecraftforge.event.AnvilUpdateEvent", "net.minecraftforge.event.AttachCapabilitiesEvent", "net.minecraftforge.event.CommandEvent", "net.minecraftforge.event.DifficultyChangeEvent", "net.minecraftforge.event.GameRuleChangeEvent", "net.minecraftforge.event.LootTableLoadEvent", "net.minecraftforge.event.RegistryEvent", "net.minecraftforge.event.ServerChatEvent", "net.minecraftforge.event.brewing.PlayerBrewedPotionEvent", "net.minecraftforge.event.brewing.PotionBrewEvent", "net.minecraftforge.event.enchanting.EnchantmentLevelSetEvent", "net.minecraftforge.event.entity.EntityJoinWorldEvent", "net.minecraftforge.event.entity.EntityMobGriefingEvent", "net.minecraftforge.event.entity.EntityMountEvent", "net.minecraftforge.event.entity.EntityStruckByLightningEvent", "net.minecraftforge.event.entity.EntityTravelToDimensionEvent", "net.minecraftforge.event.entity.PlaySoundAtEntityEvent", "net.minecraftforge.event.entity.ProjectileImpactEvent", "net.minecraftforge.event.entity.ThrowableImpactEvent", "net.minecraftforge.event.entity.item.ItemEvent", "net.minecraftforge.event.entity.item.ItemExpireEvent", "net.minecraftforge.event.entity.item.ItemTossEvent", "net.minecraftforge.event.entity.living.AnimalTameEvent", "net.minecraftforge.event.entity.living.BabyEntitySpawnEvent", "net.minecraftforge.event.entity.living.EnderTeleportEvent", "net.minecraftforge.event.entity.living.LivingAttackEvent", "net.minecraftforge.event.entity.living.LivingDamageEvent", "net.minecraftforge.event.entity.living.LivingDeathEvent", "net.minecraftforge.event.entity.living.LivingDestroyBlockEvent", "net.minecraftforge.event.entity.living.LivingDropsEvent", "net.minecraftforge.event.entity.living.LivingEntityUseItemEvent", "net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent", "net.minecraftforge.event.entity.living.LivingEvent", "net.minecraftforge.event.entity.living.LivingExperienceDropEvent", "net.minecraftforge.event.entity.living.LivingFallEvent", "net.minecraftforge.event.entity.living.LivingHealEvent", "net.minecraftforge.event.entity.living.LivingHurtEvent", "net.minecraftforge.event.entity.living.LivingKnockBackEvent", "net.minecraftforge.event.entity.living.LivingPackSizeEvent", "net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent", "net.minecraftforge.event.entity.living.LivingSpawnEvent", "net.minecraftforge.event.entity.living.LootingLevelEvent", "net.minecraftforge.event.entity.living.PotionColorCalculationEvent", "net.minecraftforge.event.entity.living.ZombieEvent", "net.minecraftforge.event.entity.minecart.MinecartCollisionEvent", "net.minecraftforge.event.entity.minecart.MinecartEvent", "net.minecraftforge.event.entity.minecart.MinecartInteractEvent", "net.minecraftforge.event.entity.minecart.MinecartUpdateEvent", "net.minecraftforge.event.entity.player.AdvancementEvent", "net.minecraftforge.event.entity.player.AnvilRepairEvent", "net.minecraftforge.event.entity.player.ArrowLooseEvent", "net.minecraftforge.event.entity.player.ArrowNockEvent", "net.minecraftforge.event.entity.player.AttackEntityEvent", "net.minecraftforge.event.entity.player.BonemealEvent", "net.minecraftforge.event.entity.player.CriticalHitEvent", "net.minecraftforge.event.entity.player.EntityItemPickupEvent", "net.minecraftforge.event.entity.player.FillBucketEvent", "net.minecraftforge.event.entity.player.ItemFishedEvent", "net.minecraftforge.event.entity.player.PlayerContainerEvent", "net.minecraftforge.event.entity.player.PlayerDestroyItemEvent", "net.minecraftforge.event.entity.player.PlayerDropsEvent", "net.minecraftforge.event.entity.player.PlayerEvent", "net.minecraftforge.event.entity.player.PlayerFlyableFallEvent", "net.minecraftforge.event.entity.player.PlayerInteractEvent", "net.minecraftforge.event.entity.player.PlayerPickupXpEvent", "net.minecraftforge.event.entity.player.PlayerSetSpawnEvent", "net.minecraftforge.event.entity.player.PlayerSleepInBedEvent", "net.minecraftforge.event.entity.player.PlayerWakeUpEvent", "net.minecraftforge.event.entity.player.SleepingLocationCheckEvent", "net.minecraftforge.event.entity.player.SleepingTimeCheckEvent", "net.minecraftforge.event.entity.player.UseHoeEvent", "net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent", "net.minecraftforge.event.world.BlockEvent", "net.minecraftforge.event.world.ChunkDataEvent", "net.minecraftforge.event.world.ChunkEvent", "net.minecraftforge.event.world.ChunkWatchEvent", "net.minecraftforge.event.world.ExplosionEvent", "net.minecraftforge.event.world.NoteBlockEvent", "net.minecraftforge.event.world.WorldEvent", "net.minecraftforge.event.entity.EntityEvent", "net.minecraftforge.fml.common.gameevent.InputEvent", "net.minecraftforge.fml.common.gameevent.PlayerEvent", "net.minecraftforge.fml.common.gameevent.TickEvent", "net.minecraftforge.fluids.FluidEvent", "net.minecraftforge.client.event.sound.PlaySoundEvent", "net.minecraftforge.client.event.sound.PlaySoundSourceEvent", "net.minecraftforge.client.event.sound.PlayStreamingSourceEvent", "net.minecraftforge.client.event.sound.SoundEvent", "net.minecraftforge.client.event.sound.SoundLoadEvent", "net.minecraftforge.client.event.sound.SoundSetupEvent", "net.minecraftforge.client.event.ClientChatEvent", "net.minecraftforge.client.event.ClientChatReceivedEvent", "net.minecraftforge.client.event.ColorHandlerEvent", "net.minecraftforge.client.event.DrawBlockHighlightEvent", "net.minecraftforge.client.event.EntityViewRenderEvent", "net.minecraftforge.client.event.FOVUpdateEvent", "net.minecraftforge.client.event.GuiContainerEvent", "net.minecraftforge.client.event.GuiOpenEvent", "net.minecraftforge.client.event.GuiScreenEvent", "net.minecraftforge.client.event.InputUpdateEvent", "net.minecraftforge.client.event.ModelBakeEvent", "net.minecraftforge.client.event.MouseEvent", "net.minecraftforge.client.event.PlayerSPPushOutOfBlocksEvent", "net.minecraftforge.client.event.RenderBlockOverlayEvent", "net.minecraftforge.client.event.RenderGameOverlayEvent", "net.minecraftforge.client.event.RenderHandEvent", "net.minecraftforge.client.event.RenderItemInFrameEvent", "net.minecraftforge.client.event.RenderLivingEvent", "net.minecraftforge.client.event.RenderPlayerEvent", "net.minecraftforge.client.event.RenderSpecificHandEvent", "net.minecraftforge.client.event.RenderTooltipEvent", "net.minecraftforge.client.event.RenderWorldLastEvent", "net.minecraftforge.client.event.ScreenshotEvent", "net.minecraftforge.client.event.TextureStitchEvent"};

    private void doCraftQuest(EntityPlayerMP player, ItemStack crafting) {
        PlayerData pdata = PlayerData.get((EntityPlayer)player);
        PlayerQuestData playerdata = pdata.questData;
        block0: for (QuestData data : playerdata.activeQuests.values()) {
            if (data.quest.step == 2 && data.quest.questInterface.isCompleted((EntityPlayer)player)) continue;
            boolean bo = data.quest.step == 1;
            for (IQuestObjective obj : data.quest.getObjectives((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player))) {
                if (data.quest.step == 1 && !bo) continue block0;
                bo = obj.isCompleted();
                if (((QuestObjective)obj).getEnumType() != EnumQuestTask.CRAFT) continue;
                int size = 0;
                if (!NoppesUtilServer.IsItemStackNull(crafting) && NoppesUtilPlayer.compareItems(obj.getItem().getMCItemStack(), crafting, obj.isIgnoreDamage(), obj.isItemIgnoreNBT())) {
                    size = crafting.func_190916_E();
                }
                if (size == 0) continue;
                HashMap<ItemStack, Integer> crafted = ((QuestObjective)obj).getCrafted(data);
                int amount = 0;
                ItemStack key = obj.getItem().getMCItemStack();
                for (ItemStack inData : crafted.keySet()) {
                    if (!NoppesUtilPlayer.compareItems(obj.getItem().getMCItemStack(), inData, obj.isIgnoreDamage(), obj.isItemIgnoreNBT())) continue;
                    amount = crafted.get(inData);
                    key = inData;
                    break;
                }
                if (amount >= obj.getMaxProgress()) continue;
                if (amount + size > obj.getMaxProgress()) {
                    size = obj.getMaxProgress() - amount;
                }
                crafted.put(key, amount += size);
                ((QuestObjective)obj).setCrafted(data, crafted);
                if (data.quest.showProgressInWindow) {
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74768_a("QuestID", data.quest.id);
                    compound.func_74778_a("Type", "craft");
                    compound.func_74783_a("Progress", new int[]{amount, obj.getMaxProgress()});
                    compound.func_74782_a("Item", (NBTBase)crafting.func_77955_b(new NBTTagCompound()));
                    compound.func_74768_a("MessageType", 0);
                    Server.sendData(player, EnumPacketClient.MESSAGE_DATA, compound);
                }
                if (data.quest.showProgressInChat) {
                    if (amount >= obj.getMaxProgress()) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("quest.message.craft.1", new Object[]{crafting.func_82833_r(), data.quest.getTitle()}));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("quest.message.craft.0", new Object[]{crafting.func_82833_r(), "" + amount, "" + obj.getMaxProgress(), data.quest.getTitle()}));
                    }
                }
                pdata.updateClient = true;
                if (obj.isItemLeave()) {
                    boolean ch = player.field_71071_by.func_70445_o().func_77969_a(crafting);
                    crafting.func_77979_a(size);
                    player.field_71070_bA.func_75142_b();
                    if (ch) {
                        NBTTagCompound nbtStack = new NBTTagCompound();
                        player.field_71071_by.func_70445_o().func_77955_b(nbtStack);
                        Server.sendData(player, EnumPacketClient.DETECT_HELD_ITEM, nbtStack);
                    }
                }
                playerdata.checkQuestCompletion((EntityPlayer)player, data);
                playerdata.updateClient = true;
            }
        }
    }

    @SubscribeEvent
    public void npcArrowLooseEvent(ArrowLooseEvent event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K || !(event.getWorld() instanceof WorldServer)) {
            return;
        }
        CustomNpcs.debugData.start(event.getEntityPlayer());
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getEntityPlayer()).scriptData;
        PlayerEvent.RangedLaunchedEvent ev = new PlayerEvent.RangedLaunchedEvent(handler.getPlayer());
        event.setCanceled(EventHooks.onPlayerRanged(handler, ev));
        CustomNpcs.debugData.end(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void npcBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K || !(event.getWorld() instanceof WorldServer)) {
            return;
        }
        CustomNpcs.debugData.start(event.getPlayer());
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getPlayer()).scriptData;
        PlayerEvent.BreakEvent ev = new PlayerEvent.BreakEvent(handler.getPlayer(), Objects.requireNonNull(NpcAPI.Instance()).getIBlock(event.getWorld(), event.getPos()), event.getExpToDrop());
        event.setCanceled(EventHooks.onPlayerBreak(handler, ev));
        event.setExpToDrop(ev.exp);
        CustomNpcs.debugData.end(event.getPlayer());
    }

    @SubscribeEvent
    public void npcBlockPlaceEvent(BlockEvent.EntityPlaceEvent event) {
        TileEntity tile;
        NBTTagCompound nbt;
        if (event.getWorld().field_72995_K || !(event.getWorld() instanceof WorldServer) || !(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        CustomNpcs.debugData.start(event.getEntity());
        EntityPlayer player = (EntityPlayer)event.getEntity();
        PlayerScriptData handler = PlayerData.get((EntityPlayer)player).scriptData;
        if (event.getPlacedBlock().func_177230_c() instanceof BlockBanner && player.func_184614_ca().func_77973_b() instanceof ItemBanner && (nbt = player.func_184614_ca().func_77978_p()) != null && nbt.func_150297_b("BlockEntityTag", 10) && nbt.func_74775_l("BlockEntityTag").func_150297_b("FactionID", 3) && (tile = event.getWorld().func_175625_s(event.getPos())) instanceof TileEntityBanner) {
            ((ITileEntityBanner)tile).npcs$setFactionId(nbt.func_74775_l("BlockEntityTag").func_74762_e("FactionID"));
        }
        PlayerEvent.PlaceEvent ev = new PlayerEvent.PlaceEvent(handler.getPlayer(), BlockWrapper.createNew(event.getWorld(), event.getPos(), event.getPlacedBlock()));
        event.setCanceled(EventHooks.onPlayerPlace(handler, ev));
        if (event.isCanceled() && event.getEntity() instanceof EntityPlayerMP) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            player.func_184614_ca().func_77955_b(nbt2);
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.DETECT_HELD_ITEM, player.field_71071_by.field_70461_c, nbt2);
        }
        CustomNpcs.debugData.end(event.getEntity());
    }

    @SubscribeEvent
    public void npcItemCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        CustomNpcs.debugData.start(event.player);
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        PlayerEvent.ItemCrafted craftEvent = new PlayerEvent.ItemCrafted(PlayerData.get((EntityPlayer)event.player).scriptData.getPlayer(), Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(event.crafting), event.craftMatrix);
        EventHooks.onEvent((IScriptHandler)PlayerData.get((EntityPlayer)event.player).scriptData, EnumScriptType.ITEM_CRAFTED, (Event)craftEvent);
        if (!craftEvent.crafting.isEmpty()) {
            CustomNPCsScheduler.runTack(() -> this.doCraftQuest(player, craftEvent.crafting.getMCItemStack()));
        }
        CustomNpcs.debugData.end(event.player);
    }

    @SubscribeEvent
    public void npcItemFishedEvent(ItemFishedEvent event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        CustomNpcs.debugData.start(event.getEntityPlayer());
        event.setCanceled(EventHooks.onPlayerFished(PlayerData.get((EntityPlayer)event.getEntityPlayer()).scriptData, (NonNullList<ItemStack>)event.getDrops(), event.getRodDamage()));
        CustomNpcs.debugData.end(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void npcItemPickupEvent(EntityItemPickupEvent event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        CustomNpcs.debugData.start(event.getEntityPlayer());
        PlayerData pd = PlayerData.get(event.getEntityPlayer());
        for (QuestData qd : pd.questData.activeQuests.values()) {
            pd.questData.checkQuestCompletion(event.getEntityPlayer(), qd);
        }
        pd.questData.updateClient = true;
        event.setCanceled(EventHooks.onPlayerPickUp(pd.scriptData, event.getItem()));
        CustomNpcs.debugData.end(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void npcItemTossEvent(ItemTossEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        CustomNpcs.debugData.start(event.getPlayer());
        PlayerData pd = PlayerData.get(event.getPlayer());
        for (QuestData qd : pd.questData.activeQuests.values()) {
            pd.questData.checkQuestCompletion(event.getPlayer(), qd);
        }
        pd.questData.updateClient = true;
        event.setCanceled(EventHooks.onPlayerToss(pd.scriptData, event.getEntityItem()));
        CustomNpcs.debugData.end(event.getPlayer());
    }

    @SubscribeEvent
    public void npcLivingAttackEvent(LivingAttackEvent event) {
        PlayerData data;
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        CustomNpcs.debugData.start(event.getEntityLiving());
        Entity source = NoppesUtilServer.GetDamageSource(event.getSource());
        String damageType = event.getSource() != null ? event.getSource().field_76373_n : "null";
        Resistances.addDamageName(damageType);
        ((IEntityLivingBaseMixin)event.getEntityLiving()).npcs$setCurrentDamageSource(event.getSource());
        if (source instanceof EntityPlayer) {
            data = PlayerData.get((EntityPlayer)source);
            PlayerScriptData handler = data.scriptData;
            ItemStack item = ((EntityPlayer)source).func_184614_ca();
            IEntity<?> target = Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)event.getEntityLiving());
            PlayerEvent.AttackEvent ev = new PlayerEvent.AttackEvent(handler.getPlayer(), 1, target);
            event.setCanceled(EventHooks.onPlayerAttack(handler, ev));
            if (event.isCanceled() || ev.isCanceled()) {
                LivingAttackEventReflection.setAmount(event, 0.0f);
            }
            if (item.func_77973_b() == CustomRegisters.scripted_item && !event.isCanceled()) {
                ItemScriptedWrapper isw = ItemScripted.GetWrapper(item);
                ItemEvent.AttackEvent eve = new ItemEvent.AttackEvent(isw, handler.getPlayer(), 1, target);
                eve.setCanceled(event.isCanceled());
                event.setCanceled(EventHooks.onScriptItemAttack(isw, eve));
            }
            if (!event.isCanceled()) {
                for (EntityNPCInterface npc : data.game.getMercenaries()) {
                    if (npc.isAttacking()) continue;
                    npc.func_70624_b(event.getEntityLiving());
                }
            }
        }
        if (event.getEntityLiving() instanceof EntityPlayer && source instanceof EntityLivingBase && !event.isCanceled()) {
            data = PlayerData.get((EntityPlayer)event.getEntityLiving());
            for (EntityNPCInterface npc : data.game.getMercenaries()) {
                if (npc.isAttacking()) continue;
                npc.func_70624_b((EntityLivingBase)source);
            }
        }
        CustomNpcs.debugData.end(event.getEntityLiving());
    }

    @SubscribeEvent
    public void npcLivingDeathEvent(LivingDeathEvent event) {
        PlayerScriptData handler;
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        CustomNpcs.debugData.start(event.getEntityLiving());
        Entity source = NoppesUtilServer.GetDamageSource(event.getSource());
        if (event.getEntityLiving() instanceof EntityPlayer) {
            handler = PlayerData.get((EntityPlayer)((EntityPlayer)event.getEntityLiving())).scriptData;
            EventHooks.onPlayerDeath(handler, event.getSource(), source);
        }
        if (source instanceof EntityPlayer) {
            handler = PlayerData.get((EntityPlayer)((EntityPlayer)source)).scriptData;
            EventHooks.onPlayerKills(handler, event.getEntityLiving());
        }
        CustomNpcs.debugData.end(event.getEntityLiving());
    }

    @SubscribeEvent
    public void npcLivingHurtEvent(LivingHurtEvent event) {
        PlayerScriptData handler;
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        CustomNpcs.debugData.start(event.getEntityLiving());
        Entity source = NoppesUtilServer.GetDamageSource(event.getSource());
        if (event.getEntityLiving() instanceof EntityPlayer) {
            handler = PlayerData.get((EntityPlayer)((EntityPlayer)event.getEntityLiving())).scriptData;
            PlayerEvent.DamagedEvent pevent = new PlayerEvent.DamagedEvent(handler.getPlayer(), source, event.getAmount(), event.getSource());
            boolean cancel = EventHooks.onPlayerDamaged(handler, pevent);
            event.setCanceled(cancel);
            if (pevent.clearTarget) {
                event.setCanceled(true);
                event.setAmount(0.0f);
            } else {
                event.setAmount(pevent.damage);
            }
        }
        if (source instanceof EntityPlayer) {
            handler = PlayerData.get((EntityPlayer)((EntityPlayer)source)).scriptData;
            PlayerEvent.DamagedEntityEvent pevent2 = new PlayerEvent.DamagedEntityEvent(handler.getPlayer(), (Entity)event.getEntityLiving(), event.getAmount(), event.getSource());
            event.setCanceled(EventHooks.onPlayerDamagedEntity(handler, pevent2));
            event.setAmount(pevent2.damage);
        }
        CustomNpcs.debugData.end(event.getEntityLiving());
    }

    @SubscribeEvent
    public void npcPlayerContainerCloseEvent(PlayerContainerEvent.Close event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        CustomNpcs.debugData.start(event.getEntityPlayer());
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getEntityPlayer()).scriptData;
        EventHooks.onPlayerContainerClose(handler, event.getContainer());
        CustomNpcs.debugData.end(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void npcPlayerContainerOpenEvent(PlayerContainerEvent.Open event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        CustomNpcs.debugData.start(event.getEntityPlayer());
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getEntityPlayer()).scriptData;
        EventHooks.onPlayerContainerOpen(handler, event.getContainer());
        CustomNpcs.debugData.end(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void npcPlayerEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        CustomNpcs.debugData.start(event.getEntityPlayer());
        if (event.getEntityPlayer().field_70170_p.field_72995_K || event.getHand() != EnumHand.MAIN_HAND || event.getWorld().field_72995_K) {
            if (event.getHand() == EnumHand.MAIN_HAND && event.getItemStack().func_77973_b() == CustomRegisters.nbt_book && event.getTarget() != null && !event.getTarget().getClass().getName().contains("minecraft") && !event.getTarget().getClass().getName().contains("noppes")) {
                ClientEventHandler.entityClientEvent(event);
            }
            CustomNpcs.debugData.end(event.getEntityPlayer());
            return;
        }
        if (event.getItemStack().func_77973_b() == CustomRegisters.nbt_book) {
            ((ItemNbtBook)event.getItemStack().func_77973_b()).entityEvent((EntityPlayerMP)event.getEntityPlayer(), event.getTarget());
            event.setCanceled(true);
            CustomNpcs.debugData.end(event.getEntityPlayer());
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getEntityPlayer()).scriptData;
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 1, Objects.requireNonNull(NpcAPI.Instance()).getIEntity(event.getTarget()));
        event.setCanceled(EventHooks.onPlayerInteract(handler, ev));
        if (event.getItemStack().func_77973_b() == CustomRegisters.scripted_item && !event.isCanceled()) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(event.getItemStack());
            ItemEvent.InteractEvent eve = new ItemEvent.InteractEvent(isw, handler.getPlayer(), 1, Objects.requireNonNull(NpcAPI.Instance()).getIEntity(event.getTarget()));
            event.setCanceled(EventHooks.onScriptItemInteract(isw, eve));
        }
        CustomNpcs.debugData.end(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void npcPlayerLeftClickBlockEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getHand() != EnumHand.MAIN_HAND || event.getEntityPlayer().field_70170_p.field_72995_K || event.getWorld().field_72995_K) {
            return;
        }
        CustomNpcs.debugData.start(event.getEntityPlayer());
        if (event.getItemStack().func_77973_b() == CustomRegisters.npcboundary) {
            ((ItemBoundary)event.getItemStack().func_77973_b()).leftClick(event.getItemStack(), (EntityPlayerMP)event.getEntityPlayer());
            event.setCanceled(true);
            CustomNpcs.debugData.end(event.getEntityPlayer());
            return;
        }
        if (event.getItemStack().func_77973_b() instanceof ISpecBuilder) {
            ((ISpecBuilder)event.getItemStack().func_77973_b()).leftClick(event.getItemStack(), (EntityPlayerMP)event.getEntityPlayer(), event.getPos());
            event.setCanceled(true);
            CustomNpcs.debugData.end(event.getEntityPlayer());
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getEntityPlayer()).scriptData;
        PlayerEvent.AttackEvent ev = new PlayerEvent.AttackEvent(handler.getPlayer(), 2, Objects.requireNonNull(NpcAPI.Instance()).getIBlock(event.getWorld(), event.getPos()));
        event.setCanceled(EventHooks.onPlayerAttack(handler, ev));
        if (event.getItemStack().func_77973_b() == CustomRegisters.scripted_item && !event.isCanceled()) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(event.getItemStack());
            ItemEvent.AttackEvent eve = new ItemEvent.AttackEvent(isw, handler.getPlayer(), 2, Objects.requireNonNull(NpcAPI.Instance()).getIBlock(event.getWorld(), event.getPos()));
            eve.setCanceled(event.isCanceled());
            event.setCanceled(EventHooks.onScriptItemAttack(isw, eve));
        }
        CustomNpcs.debugData.end(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void npcPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        NoppesUtilServer.sendScriptErrorsTo(event.player);
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        if (!ScriptController.Instance.getErrored().isEmpty()) {
            CustomNPCsScheduler.runTack(() -> event.player.func_145747_a((ITextComponent)new TextComponentTranslation("command.script.logs.view", new Object[0])), 2500);
        }
        CustomNpcs.debugData.start(event.player);
        final PlayerData data = PlayerData.get(event.player);
        EventHooks.onPlayerLogin(data.scriptData);
        final EntityPlayerMP player = (EntityPlayerMP)event.player;
        PlayerSkinController.getInstance().logged(player);
        MinecraftServer server = event.player.func_184102_h();
        assert (server != null);
        for (WorldServer world : server.field_71305_c) {
            ServerScoreboard board = (ServerScoreboard)world.func_96441_U();
            for (String objective : Availability.scores) {
                ScoreObjective so = board.func_96518_b(objective);
                if (so == null) continue;
                if (board.func_96552_h(so) == 0) {
                    player.field_71135_a.func_147359_a((Packet)new SPacketScoreboardObjective(so, 0));
                }
                Score sco = board.func_96529_a(player.func_70005_c_(), so);
                player.field_71135_a.func_147359_a((Packet)new SPacketUpdateScore(sco));
            }
        }
        event.player.field_71069_bz.func_75132_a(new IContainerListener(){

            public void func_71110_a(@Nonnull Container containerToSend, @Nonnull NonNullList<ItemStack> itemsList) {
            }

            public void func_175173_a(@Nonnull Container containerIn, @Nonnull IInventory inventory) {
            }

            public void func_71111_a(@Nonnull Container containerToSend, int slotInd, @Nonnull ItemStack stack) {
                if (player.field_70170_p.field_72995_K) {
                    return;
                }
                for (QuestData qd : data.questData.activeQuests.values()) {
                    for (IQuestObjective obj : qd.quest.getObjectives((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player))) {
                        if (obj.getType() != 0) continue;
                        data.questData.checkQuestCompletion((EntityPlayer)player, qd);
                    }
                }
            }

            public void func_71112_a(@Nonnull Container containerIn, int varToUpdate, int newValue) {
            }
        });
        int[] array = DimensionHandler.getInstance().getAllIDs();
        Server.sendData(player, EnumPacketClient.DIMENSION_IDS, new Object[]{array});
        RecipeController.getInstance().checkRecipeBook((EntityPlayerMP)event.player);
        SyncController.syncPlayer((EntityPlayerMP)event.player);
        if (data.game.logPos != null) {
            NoppesUtilPlayer.teleportPlayer((EntityPlayerMP)event.player, data.game.logPos[0], data.game.logPos[1], data.game.logPos[2], (int)data.game.logPos[3], event.player.field_70177_z, event.player.field_70125_A);
        }
        data.game.dimID = player.field_70170_p.field_73011_w.getDimension();
        CustomNpcs.debugData.end(event.player);
    }

    @SubscribeEvent
    public void npcPlayerLogoutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        IWorldInfo dim;
        CustomNpcs.debugData.start(event.player);
        if (event.player.field_70170_p.field_72995_K) {
            KeyController.getInstance().save();
            CustomNpcs.debugData.end(event.player);
            return;
        }
        PlayerData data = PlayerData.get(event.player);
        EventHooks.onPlayerLogout(data.scriptData);
        if (data.bankData.lastBank != null) {
            data.bankData.lastBank.save();
            data.bankData.lastBank = null;
        }
        if ((dim = DimensionHandler.getInstance().getMCWorldInfo(event.player.field_70170_p.field_73011_w.getDimension())) instanceof CustomWorldInfo) {
            data.game.logPos = new double[]{event.player.field_70165_t, event.player.field_70163_u, event.player.field_70161_v, event.player.field_70170_p.field_73011_w.getDimension()};
            WorldServer world = Objects.requireNonNull(event.player.func_184102_h()).func_71218_a(0);
            BlockPos coords = world.func_180504_m();
            if (coords == null) {
                coords = world.func_175694_M();
            }
            if (!world.func_175623_d(coords)) {
                coords = world.func_175672_r(coords);
            } else if (!world.func_175623_d(coords.func_177984_a())) {
                while (world.func_175623_d(coords) && coords.func_177956_o() > 0) {
                    coords = coords.func_177977_b();
                }
                if (coords.func_177956_o() == 0) {
                    coords = world.func_175672_r(coords);
                }
            }
            double x = coords.func_177958_n();
            double y = coords.func_177956_o();
            double z = coords.func_177952_p();
            NoppesUtilPlayer.teleportPlayer((EntityPlayerMP)event.player, x, y, z, 0, event.player.field_70177_z, event.player.field_70125_A);
        } else {
            data.game.logPos = null;
        }
        data.save(false);
        CustomNpcs.debugData.end(event.player);
    }

    @SubscribeEvent
    public void npcPlayerRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        Entity deadTarget;
        if (event.getHand() != EnumHand.MAIN_HAND || event.getWorld().field_72995_K) {
            return;
        }
        CustomNpcs.debugData.start(event.getEntityPlayer());
        if (!(event.getItemStack().func_77973_b() instanceof INPCToolItem) && (deadTarget = Util.instance.getLookEntity((Entity)event.getEntityPlayer(), 4.0, false)) != null && !deadTarget.func_70089_S() && deadTarget instanceof EntityNPCInterface) {
            DataInventory dataInv = ((EntityNPCInterface)deadTarget).inventory;
            InventoryBasic deadInventory = dataInv.deadLoot;
            if (deadInventory == null && dataInv.deadLoots != null && dataInv.deadLoots.containsKey(event.getEntityPlayer())) {
                deadInventory = (IInventory)dataInv.deadLoots.get(event.getEntityPlayer());
            }
            if (deadInventory != null) {
                NoppesUtilServer.sendOpenGui(event.getEntityPlayer(), EnumGuiType.DeadInventory, (EntityNPCInterface)deadTarget, deadInventory.func_70302_i_(), -1, 0);
                event.setCanceled(true);
                CustomNpcs.debugData.end(event.getEntityPlayer());
                return;
            }
        }
        if (event.getItemStack().func_77973_b() == CustomRegisters.nbt_book) {
            Entity target = Util.instance.getLookEntity((Entity)event.getEntityPlayer(), PlayerData.get((EntityPlayer)event.getEntityPlayer()).game.renderDistance, false);
            if (target != null) {
                ((ItemNbtBook)event.getItemStack().func_77973_b()).entityEvent((EntityPlayerMP)event.getEntityPlayer(), target);
            } else {
                ((ItemNbtBook)event.getItemStack().func_77973_b()).blockEvent((EntityPlayerMP)event.getEntityPlayer(), event.getPos());
            }
            event.setCanceled(true);
            CustomNpcs.debugData.end(event.getEntityPlayer());
            return;
        }
        if (event.getItemStack().func_77973_b() == CustomRegisters.npcboundary) {
            ((ItemBoundary)event.getItemStack().func_77973_b()).rightClick(event.getItemStack(), (EntityPlayerMP)event.getEntityPlayer());
            CustomNpcs.debugData.end(event.getEntityPlayer());
            event.setCanceled(true);
            return;
        }
        if (event.getItemStack().func_77973_b() instanceof ISpecBuilder) {
            ((ISpecBuilder)event.getItemStack().func_77973_b()).rightClick(event.getItemStack(), (EntityPlayerMP)event.getEntityPlayer(), event.getPos());
            CustomNpcs.debugData.end(event.getEntityPlayer());
            event.setCanceled(true);
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getEntityPlayer()).scriptData;
        handler.hadInteract = true;
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 2, Objects.requireNonNull(NpcAPI.Instance()).getIBlock(event.getWorld(), event.getPos()));
        event.setCanceled(EventHooks.onPlayerInteract(handler, ev));
        if (event.getItemStack().func_77973_b() == CustomRegisters.scripted_item && !event.isCanceled()) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(event.getItemStack());
            ItemEvent.InteractEvent eve = new ItemEvent.InteractEvent(isw, handler.getPlayer(), 2, Objects.requireNonNull(NpcAPI.Instance()).getIBlock(event.getWorld(), event.getPos()));
            event.setCanceled(EventHooks.onScriptItemInteract(isw, eve));
        }
        CustomNpcs.debugData.end(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void npcPlayerRightClickItemEvent(PlayerInteractEvent.RightClickItem event) {
        Entity deadTarget;
        if (event.getHand() != EnumHand.MAIN_HAND || event.getEntityPlayer().field_70170_p.field_72995_K || event.getWorld().field_72995_K) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
        CustomNpcs.debugData.start(player);
        if (event.getEntityPlayer().func_184812_l_() && event.getEntityPlayer().func_70093_af() && event.getItemStack().func_77973_b() == CustomRegisters.scripted_item) {
            NoppesUtilServer.sendOpenGui(event.getEntityPlayer(), EnumGuiType.ScriptItem, null);
            CustomNpcs.debugData.end(player);
            return;
        }
        if (!(event.getItemStack().func_77973_b() instanceof INPCToolItem) && (deadTarget = Util.instance.getLookEntity((Entity)event.getEntityPlayer(), 4.0, false)) != null && !deadTarget.func_70089_S() && deadTarget instanceof EntityNPCInterface) {
            DataInventory dataInv = ((EntityNPCInterface)deadTarget).inventory;
            InventoryBasic deadInventory = dataInv.deadLoot;
            if (deadInventory == null && dataInv.deadLoots != null && dataInv.deadLoots.containsKey(event.getEntityPlayer())) {
                deadInventory = (IInventory)dataInv.deadLoots.get(event.getEntityPlayer());
            }
            if (deadInventory != null) {
                NoppesUtilServer.sendOpenGui(event.getEntityPlayer(), EnumGuiType.DeadInventory, (EntityNPCInterface)deadTarget, deadInventory.func_70302_i_(), -1, 0);
                event.setCanceled(true);
                CustomNpcs.debugData.end(player);
                return;
            }
        }
        if (event.getItemStack().func_77973_b() instanceof ItemNbtBook) {
            PlayerData data = PlayerData.get((EntityPlayer)player);
            double d0 = data.game.renderDistance;
            Entity target = Util.instance.getLookEntity((Entity)player, d0, false);
            if (target != null) {
                ((ItemNbtBook)event.getItemStack().func_77973_b()).entityEvent(player, target);
                CustomNpcs.debugData.end(player);
                return;
            }
            if (!player.func_184592_cb().func_190926_b()) {
                ((ItemNbtBook)event.getItemStack().func_77973_b()).itemEvent(player);
                CustomNpcs.debugData.end(player);
                return;
            }
            Vec3d vec3d = player.func_174824_e(1.0f);
            Vec3d vec3d2 = player.func_70676_i(1.0f);
            Vec3d vec3d3 = vec3d.func_72441_c(vec3d2.field_72450_a * d0, vec3d2.field_72448_b * d0, vec3d2.field_72449_c * d0);
            RayTraceResult result = player.field_70170_p.func_147447_a(vec3d, vec3d3, false, false, false);
            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                ((ItemNbtBook)event.getItemStack().func_77973_b()).blockEvent(player, result.func_178782_a());
                CustomNpcs.debugData.end(player);
                return;
            }
        }
        if (event.getItemStack().func_77973_b() instanceof ItemBoundary) {
            ((ItemBoundary)event.getItemStack().func_77973_b()).rightClick(event.getItemStack(), (EntityPlayerMP)event.getEntityPlayer());
            CustomNpcs.debugData.end(player);
            return;
        }
        if (event.getItemStack().func_77973_b() instanceof ISpecBuilder) {
            ((ISpecBuilder)event.getItemStack().func_77973_b()).rightClick(event.getItemStack(), (EntityPlayerMP)event.getEntityPlayer(), event.getPos());
            CustomNpcs.debugData.end(player);
            event.setCanceled(true);
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getEntityPlayer()).scriptData;
        if (handler.hadInteract) {
            handler.hadInteract = false;
            CustomNpcs.debugData.end(player);
            return;
        }
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 0, null);
        event.setCanceled(EventHooks.onPlayerInteract(handler, ev));
        if (event.getItemStack().func_77973_b() == CustomRegisters.scripted_item && !event.isCanceled()) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(event.getItemStack());
            ItemEvent.InteractEvent eve = new ItemEvent.InteractEvent(isw, handler.getPlayer(), 0, null);
            event.setCanceled(EventHooks.onScriptItemInteract(isw, eve));
        }
        CustomNpcs.debugData.end(player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void npcServerChatEvent(ServerChatEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K || event.getPlayer() == EntityNPCInterface.ChatEventPlayer) {
            return;
        }
        CustomNpcs.debugData.start(event.getPlayer());
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getPlayer()).scriptData;
        String message = event.getMessage();
        PlayerEvent.ChatEvent ev = new PlayerEvent.ChatEvent(handler.getPlayer(), event.getMessage());
        EventHooks.onPlayerChat(handler, ev);
        event.setCanceled(ev.isCanceled());
        if (!message.equals(ev.message)) {
            TextComponentTranslation chat = new TextComponentTranslation("", new Object[0]);
            chat.func_150257_a(ForgeHooks.newChatWithLinks((String)ev.message));
            event.setComponent((ITextComponent)chat);
        }
        Server.sendRangedData(event.getPlayer().field_70170_p, event.getPlayer().func_180425_c(), 32, EnumPacketClient.CHAT_BUBBLE, event.getPlayer().func_145782_y(), event.getMessage(), true);
        CustomNpcs.debugData.end(event.getPlayer());
    }

    @SubscribeEvent
    public void npcServerTick(TickEvent.PlayerTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        CustomNpcs.debugData.start(event.player);
        EntityPlayer player = event.player;
        PlayerData data = PlayerData.get(player);
        if (player.field_70173_aa % 10 == 0) {
            EventHooks.onPlayerTick(data.scriptData);
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack item = player.field_71071_by.func_70301_a(i);
                if (item.func_190926_b() || item.func_77973_b() != CustomRegisters.scripted_item) continue;
                ItemScriptedWrapper isw = (ItemScriptedWrapper)Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(item);
                EventHooks.onScriptItemUpdate(isw, player);
                if (!isw.updateClient) continue;
                isw.updateClient = false;
                Server.sendData((EntityPlayerMP)player, EnumPacketClient.UPDATE_ITEM, i, isw.getMCNbt());
            }
        }
        if (data.playerLevel != player.field_71068_ca) {
            EventHooks.onPlayerLevelUp(data.scriptData, data.playerLevel - player.field_71068_ca);
            data.playerLevel = player.field_71068_ca;
        }
        data.timers.update();
        int dimId = event.player.field_70170_p.field_73011_w.getDimension();
        if (data.game.dimID != dimId) {
            if (CustomNpcs.SetPlayerHomeWhenChangingDimension) {
                player.setSpawnDimension(Integer.valueOf(dimId));
                player.func_180473_a(player.func_180425_c(), true);
                player.setSpawnChunk(player.func_180425_c(), true, dimId);
                player.field_71081_bT = player.func_180425_c();
                ((IEntityPlayerMixin)player).npcs$setSpawnPos(player.func_180425_c());
            }
            data.game.dimID = event.player.field_70170_p.field_73011_w.getDimension();
        }
        CustomNpcs.debugData.end(event.player);
    }

    /*
     * Could not resolve type clashes
     */
    public PlayerEventHandler registerForgeEvents(Side side) {
        ArrayList listClasses;
        block24: {
            ForgeEventHandler handler = new ForgeEventHandler();
            LogWriter.info("CustomNpcs: Start load Forge Events:");
            CustomNpcs.debugData.start(null);
            ScriptController.forgeEventNames.clear();
            listClasses = new ArrayList();
            try {
                Method m = handler.getClass().getMethod("forgeEntity", Event.class);
                Method register = MinecraftForge.EVENT_BUS.getClass().getDeclaredMethod("register", Class.class, Object.class, Method.class, ModContainer.class);
                register.setAccessible(true);
                for (String forgeEventClassPath : pathsToForgeEventClasses) {
                    Class<?> event;
                    try {
                        event = Class.forName(forgeEventClassPath);
                    }
                    catch (ClassNotFoundException e) {
                        continue;
                    }
                    if (listClasses.contains(event)) continue;
                    listClasses.add(event);
                }
                int eventSize = pathsToForgeEventClasses.length;
                LogWriter.debug("Manually found " + listClasses.size() + " / " + eventSize + " classes of Forge events");
                ClassPath loader = ClassPath.from((ClassLoader)this.getClass().getClassLoader());
                ArrayList list = new ArrayList(loader.getTopLevelClassesRecursive("net.minecraftforge.event"));
                list.addAll(loader.getTopLevelClassesRecursive("net.minecraftforge.fml.common"));
                if (eventSize < list.size()) {
                    eventSize = list.size();
                }
                for (ClassPath.ClassInfo info : list) {
                    String forgeEventClassPath = info.getName();
                    if (forgeEventClassPath.startsWith("net.minecraftforge.event.terraingen")) continue;
                    try {
                        Class<?> event = Class.forName(forgeEventClassPath);
                        if (listClasses.contains(event)) continue;
                        listClasses.add(event);
                    }
                    catch (Throwable event) {}
                }
                if (eventSize < listClasses.size()) {
                    eventSize = listClasses.size();
                }
                LogWriter.debug("Total of " + listClasses.size() + " / " + eventSize + " classes of Forge events");
                ArrayList<Class<WorldEvent.PotentialSpawns>> notAssingException = new ArrayList<Class<WorldEvent.PotentialSpawns>>();
                notAssingException.add(GenericEvent.class);
                notAssingException.add(EntityEvent.EntityConstructing.class);
                notAssingException.add(WorldEvent.PotentialSpawns.class);
                ArrayList<Class<FMLNetworkEvent.ClientCustomPacketEvent>> isClientEvents = new ArrayList<Class<FMLNetworkEvent.ClientCustomPacketEvent>>();
                isClientEvents.add(ItemTooltipEvent.class);
                isClientEvents.add(GetCollisionBoxesEvent.class);
                isClientEvents.add(TickEvent.RenderTickEvent.class);
                isClientEvents.add(TickEvent.ClientTickEvent.class);
                isClientEvents.add(FMLNetworkEvent.ClientCustomPacketEvent.class);
                boolean threadIsClient = Thread.currentThread().getName().toLowerCase().contains("client");
                for (Class infoClass : listClasses) {
                    boolean isClient = false;
                    Class debugClass = null;
                    try {
                        String pfx = "";
                        ArrayList classes = new ArrayList(Arrays.asList(infoClass.getDeclaredClasses()));
                        if (classes.isEmpty()) {
                            classes.add(infoClass);
                        }
                        Iterator iterator = classes.iterator();
                        while (iterator.hasNext()) {
                            Class c;
                            debugClass = c = (Class)iterator.next();
                            boolean canAdd = true;
                            for (Class nae : notAssingException) {
                                if (!nae.isAssignableFrom(c)) continue;
                                canAdd = false;
                                break;
                            }
                            isClient = false;
                            for (Class nae : isClientEvents) {
                                if (!nae.isAssignableFrom(c)) continue;
                                isClient = true;
                                break;
                            }
                            if (side == Side.SERVER && isClient || !canAdd || !Event.class.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers()) || !Modifier.isPublic(c.getModifiers()) || ScriptController.forgeEventNames.containsKey(c)) continue;
                            String eventName = c.getName();
                            if (!isClient) {
                                isClient = eventName.toLowerCase().contains("client") || eventName.toLowerCase().contains("render");
                            }
                            int i = eventName.lastIndexOf(".");
                            eventName = pfx + StringUtils.uncapitalize((String)eventName.substring(i + 1).replace("$", ""));
                            if (ScriptController.forgeEventNames.containsValue(eventName)) continue;
                            if (!isClient) {
                                ScriptController.forgeEventNames.put(c, eventName);
                                ScriptController.forgeClientEventNames.put(c, eventName);
                                register.invoke((Object)MinecraftForge.EVENT_BUS, c, handler, m, Loader.instance().activeModContainer());
                            } else {
                                ScriptController.forgeClientEventNames.put(c, eventName);
                                if (threadIsClient) {
                                    register.invoke((Object)MinecraftForge.EVENT_BUS, c, handler, m, Loader.instance().activeModContainer());
                                }
                            }
                            LogWriter.debug("Add Forge " + (isClient ? "client" : "common") + " Event " + c.getName());
                        }
                    }
                    catch (Exception t) {
                        LogWriter.error("[" + side + "] CustomNpcs Error Register Forge " + (isClient ? "client" : "server") + " Event: " + infoClass.getSimpleName() + (debugClass != null ? "; subClass: " + debugClass.getSimpleName() : ""), t);
                    }
                }
                if (!PixelmonHelper.Enabled) break block24;
                try {
                    Field f = ClassLoader.class.getDeclaredField("classes");
                    f.setAccessible(true);
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    ArrayList classes2 = new ArrayList((Collection)f.get(classLoader));
                    for (Class c2 : classes2) {
                        if (!c2.getName().startsWith("com.pixelmonmod.pixelmon.api.events") || !Event.class.isAssignableFrom(c2) || Modifier.isAbstract(c2.getModifiers()) || !Modifier.isPublic(c2.getModifiers()) || ScriptController.forgeEventNames.containsKey(c2)) continue;
                        String eventName = c2.getName();
                        int i = eventName.lastIndexOf(".");
                        if (ScriptController.forgeEventNames.containsValue(eventName = StringUtils.uncapitalize((String)eventName.substring(i + 1).replace("$", "")))) continue;
                        register.invoke((Object)PixelmonHelper.EVENT_BUS, c2, handler, m, Loader.instance().activeModContainer());
                        ScriptController.forgeEventNames.put(c2, eventName);
                        LogWriter.debug("Add Pixelmon Event[" + ScriptController.forgeEventNames.size() + "]; " + c2.getName());
                    }
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        LogWriter.info("CustomNpcs: Registered [Client:" + ScriptController.forgeClientEventNames.size() + "; Server: " + ScriptController.forgeEventNames.size() + "] Forge Events out of [" + listClasses.size() + "] classes");
        CustomNpcs.debugData.end(null);
        return this;
    }

    @SubscribeEvent
    public void npcLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        CustomNPCsScheduler.runTack(() -> {
            if (player instanceof EntityPlayerMP) {
                // empty if block
            }
        });
    }

    public static class ForgeEventHandler {
        @SubscribeEvent
        public void forgeEntity(Event event) {
            if (!CustomNpcs.EnableForgeScripting) {
                return;
            }
            EventHooks.onForgeEvent(event);
        }
    }
}

